$ENGINE=VBScript
'*************************************************************
'* Standard Deviation Plot.vbs Rev 5                         *
'* Created at 14:51 on Tuesday, April 12 2016                *
'* (C) FEA Ltd 2016                                          *
'* Standard Deviation Plot - User Results                    *
'*************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS  *
'* NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS *
'* IS BASIS FOR DEMONSTRATION PURPOSES.                      *
'*************************************************************
'
' flush results column
database.flushScriptedResults()
' Prevent automatic refreshing of the graphics window whilst running the script
Call setManualRefresh(1)
On Error Resume Next

Const NameOfScript = "Standard Deviation Plot"

' Obtain user's choice of results entity
urentity = InputBox("Enter the name of a Stress or Strain results entity that you wish to use:" & Chr(13) & Chr(13) & "For example:" & Chr(13) & "Stress (top) - Thick Shell" & Chr(13) & "Stress - Plane Stress" & Chr(13) & "Stress - Solids" & Chr(13) & Chr(13) & "Continuous entities such as Displacement cannot be used.  The name of the entity is case sensitive.")

' Obtain stress model from results entity entered by removing possibe characters form the string urentity to achieve the string urStressModel 
urStressModel = Replace(urentity, "Stress ", "", 1, -1, vbTextCompare)
urStressModel = Replace(urStressModel, "Strain ", "", 1, -1, vbTextCompare)
urStressModel = Replace(urStressModel, "- ", "", 1, -1, vbTextCompare)
urStressModel = Replace(urStressModel, "(top) ", "", 1, -1, vbTextCompare)
urStressModel = Replace(urStressModel, "(middle) ", "", 1, -1, vbTextCompare)
urStressModel = Replace(urStressModel, "(bottom) ", "", 1, -1, vbTextCompare)

' extract array of nodes suitable for the results entity specified in model
call database.options.setBoolean("associateDown", false)
set Selected = newGeometrySet()
call Selected.add(urStressModel, "Element")
' extract array of nodes for the valid elements
call Selected.addLOF("Node")
call Selected.remove(urStressModel, "Element")
call database.options.setBoolean("associateDown", true)
nodes = Selected.getObjects("Nodes", "All")

' Check the user's specified results entity is suitable and give an error message if not
If ubound(nodes) = -1 Then
msgbox "Error: The specified results entity " & urentity & " is not suitable for the elements in the model.  Check the entities listed for a Contours plot and ensure that the spelling is correct.  Note that the input of entity and component is case sensitive.", vbCritical + vbOKOnly, NameOfScript
setManualRefresh(0)
StopScript
End If

' Obtain user's choice of component
urcomponent = InputBox("Enter the name of the component that you wish to use" & Chr(13) & Chr(13) & "For example:" & Chr(13) & "My" & Chr(13) & "SE")

' Set name
urname = "SD of nodal values of " & urcomponent
urnamediv = "SD of nodal values of " & urcomponent & "/Max Abs"

' set the entity name of the scripted results
db.setScriptedResultsEntity("User Results")
' Declare array of unaveraged nodal values
Dim unavNodalVal()

' Determine the maximum absolute unaveraged nodal value for the visible model for the active loadcase, specified entity and specified component
call view.getElementNodalResultsMaxMin(urentity, urcomponent, maxValue, minValue, maxElement, minElement, maxNode, minNode)
If abs(maxValue) > abs(minValue) Then maxabs = abs(maxValue) Else maxabs = abs(minValue) End If

' Process formula and create user results column
' loop nodes

For j = 0 to ubound(nodes)
' Extract averaged nodal value
    avNodalVal = nodes(j).getResults(urentity, urcomponent)

    var = 0

' set node object
    set node = nodes(j)

' extract array of valid elements for the current node
    set elementobjs = newGeometrySet()
    call elementobjs.add("Node", node.getID)
    call elementobjs.addHOF("Element")
    call elementobjs.keep(urStressModel, "Element")
    elements = elementobjs.getObjects("Elements", "All")
    set elementobjs = nothing
    eltnum = ubound(elements)
    ReDim unavNodalVal(eltnum)

' loop element nodal values to obtain variance
    For i = 0 to eltnum
' extract unaveraged nodal value
        unavNodalVal(i) = elements(i).getNodeResults(node, urentity ,urcomponent)
	var = var + (avNodalVal - unavNodalVal(i))^2
    Next

' set averaged nodal value for SD
    Call nodes(j).setScriptedResults((var/(eltnum+1))^0.5, urname)
' set averaged nodal value for SD divided by maximum absolute unaveraged nodal value for the visible model for the active loadcase, specified entity and specified component
    Call nodes(j).setScriptedResults((var/(eltnum+1))^0.5/maxabs, urnamediv)

' loop elements to set unaveraged nodal values - TAKES A WHILE - JUST NEED TO FORCE A SMOOTHED PLOT OR AVERAGED VALUES ONLY
    'For i = 0 to eltnum
' set unaveraged nodal value for SD
    '	Call elements(i).setNodeScriptedResults(node, (var/(eltnum+1))^0.5, urname)
' set averaged nodal value for SD divided by the maximum absolute unaveraged nodal value for the visible model for the active loadcase, specified entity and specified component
    '	Call elements(i).setNodeScriptedResults(node, (var/(eltnum+1))^0.5/maxabs, urnamediv)
    'Next
Next

' Display Results
' Check if there is a post processing layer present
PostProcessLayer = False

' Display contours of user results if the contours layer is present in the current view
If view.existsContoursLayer() = 1 Then
    call view.insertContoursLayer()
    call view.contours.setResults("User Results", urname)
    call view.contours.setShowSmoothed(true)
    PostProcessLayer = True
End If

' Display values of user results if the values layer is present in the current view
If view.existsValuesLayer() = 1 Then
    call view.insertValuesLayer()
    call view.values.setResults("User Results", urname)
' Force averaged nodal values to be displayed
    call view.values.setShowAtElementNodes(false)
    PostProcessLayer = True
End If

' Report to user if there is no post-processing layer present
If PostProcessLayer = False Then
MsgBox "There is no Contours, or Values layer present.  The results created will be found under the entity 'User Results' and the components '" & urname & "' and '" & urnamediv & "' for averaged values and smoothed plots only", vbOKOnly, NameOfScript
End If

' Turn automatic refreshing of the graphics window back on
Call setManualRefresh(0)